#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.interface import Attribute
    from zope.schema import Bool, Int

    from pyams_gis.interfaces.configuration import IMapConfiguration

    from pyams_default_theme import _


    class IBaseMapRendererSettings(IMapConfiguration):
        """Base map renderer settings"""

        no_use_default_map_configuration = Bool(title=_("Don't use default configuration?"),
                                                required=True,
                                                default=False)

        use_default_map_configuration = Bool(title=_("Use default configuration?"),
                                             required=True,
                                             default=True)

        configuration = Attribute("Map configuration")

        map_height = Int(title=_("Map height"),
                         description=_("Map height, in pixels"),
                         required=True,
                         default=400)


    class IMapParagraphDefaultRendererSettings(IBaseMapRendererSettings):
        """Map paragraph default renderer settings interface"""
