#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    import json

    from zope.schema.fieldproperty import FieldProperty

    from pyams_content.component.map.interfaces import IMapParagraph
    from pyams_content.features.renderer.interfaces import IContentRenderer
    from pyams_default_theme.component.map.interfaces import IBaseMapRendererSettings, \
        IMapParagraphDefaultRendererSettings
    from pyams_default_theme.features.renderer import BaseContentRenderer
    from pyams_gis.configuration import MapConfiguration
    from pyams_gis.interfaces.configuration import IMapConfiguration
    from pyams_gis.interfaces.utility import IMapManager
    from pyams_skin.layer import IPyAMSLayer
    from pyams_template.template import template_config
    from pyams_utils.adapter import adapter_config, get_annotation_adapter
    from pyams_utils.factory import factory_config
    from pyams_utils.registry import get_utility

    from pyams_default_theme import _


    #
    # Map paragraph default renderer settings
    #

    MAP_DEFAULT_RENDERER_SETTINGS_KEY = 'pyams_content.map.renderer:default'


    class BaseMapRendererSettings(MapConfiguration):
        """Base map renderer settings"""

        _use_default_map_configuration = FieldProperty(IBaseMapRendererSettings[
                                                           'use_default_map_configuration'])

        map_height = FieldProperty(IBaseMapRendererSettings['map_height'])

        @property
        def use_default_map_configuration(self):
            return self._use_default_map_configuration

        @use_default_map_configuration.setter
        def use_default_map_configuration(self, value):
            self._use_default_map_configuration = value

        @property
        def no_use_default_map_configuration(self):
            return not bool(self.use_default_map_configuration)

        @no_use_default_map_configuration.setter
        def no_use_default_map_configuration(self, value):
            self.use_default_map_configuration = not bool(value)

        @property
        def configuration(self):
            if self.use_default_map_configuration:
                manager = get_utility(IMapManager)
                return IMapConfiguration(manager).get_configuration()
            return self.get_configuration()


    @factory_config(IMapParagraphDefaultRendererSettings)
    class MapParagraphDefaultRendererSettings(BaseMapRendererSettings):
        """Map paragraph default renderer settings"""


    @adapter_config(context=IMapParagraph,
                    provides=IMapParagraphDefaultRendererSettings)
    def map_paragraph_default_renderer_settings_factory(context):
        """Map paragraph default renderer settings factory"""
        return get_annotation_adapter(context, MAP_DEFAULT_RENDERER_SETTINGS_KEY,
                                      IMapParagraphDefaultRendererSettings)


    #
    # Map paragraph default renderer
    #

    @adapter_config(name='default',
                    context=(IMapParagraph, IPyAMSLayer),
                    provides=IContentRenderer)
    @template_config(template='templates/map-default.pt', layer=IPyAMSLayer)
    class MapParagraphDefaultRenderer(BaseContentRenderer):
        """Map paragraph default renderer"""

        label = _("Default map renderer")

        settings_interface = IMapParagraphDefaultRendererSettings

        i18n_context_attrs = ('title', )

        def get_map_configuration(self):
            configuration = self.settings.configuration
            if self.context.gps_location and self.context.display_marker:
                coordinates = self.context.gps_location.wgs_coordinates
                configuration['marker'] = {
                    'lat': float(coordinates[1]),
                    'lon': float(coordinates[0])
                }
            return json.dumps(configuration)
