#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.component.keynumber.portlet.interfaces import IKeyNumberPortletSettings
from pyams_content.component.links import IInternalLink
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_workflow.interfaces import IWorkflowPublicationInfo

# import packages
from pyams_portal.portlet import PortletRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from zope.interface import Interface

from pyams_default_theme import _


class KeyNumberPortletBaseRenderer(PortletRenderer):
    """Key numbers portlet default renderer"""

    def get_link_info(cls, link):
        return IAssociationInfo(link)

    @classmethod
    def get_link_status(cls, link):
        if not IInternalLink.providedBy(link):
            return True
        target = link.get_target()
        return (target is not None) and IWorkflowPublicationInfo(target).is_published()


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IKeyNumberPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/horizontal-render.pt', layer=IPyAMSLayer)
class KeyNumberPortletHorizontalRenderer(KeyNumberPortletBaseRenderer):
    """Key numbers portlet horizontal renderer"""

    label = _("Horizontal list with carousel")


@adapter_config(name='vertical', context=(IPortalContext, IPyAMSLayer, Interface, IKeyNumberPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/vertical-render.pt', layer=IPyAMSLayer)
class KeyNumberPortletVerticalRenderer(KeyNumberPortletBaseRenderer):
    """Key numbers portlet vertical renderer"""

    label = _("Vertical list")
