#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.keynumber.interfaces import IKeyNumberContainer, IKeyNumberParagraph
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from pyams_default_theme import _


#
#  Base Key numbers paragraph renderer
#

class BaseKeyNumberParagraphRenderer(BaseContentRenderer):
    """Default Key Numbers renderer"""

    i18n_context_attrs = ('title', )

    @property
    def keynumbers(self):
        return IKeyNumberContainer(self.context)


#
#  Key numbers paragraph default renderer
#

@adapter_config(name='default', context=(IKeyNumberParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/keynumber-default.pt', layer=IPyAMSLayer)
class DefaultKeyNumberParagraphRenderer(BaseKeyNumberParagraphRenderer):
    """Default Key Numbers renderer"""

    label = _("Default key numbers renderer")
    weight = 1
