#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Bool


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


class IIllustrationPortletDefaultRendererSettings(Interface):
    """Illustration portlet default renderer settings"""

    show_border = Bool(title=_("Show image border?"),
                       description=_("If 'yes', a thin border will be added to illustration"),
                       required=True,
                       default=False)
