#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration import IIllustration
from pyams_content.component.illustration.portlet import IIllustrationPortletSettings
from pyams_content.component.illustration.portlet.interfaces import IIllustrationPortletContent
from pyams_content.features.renderer.interfaces import HIDDEN_RENDERER_NAME
from pyams_default_theme import _
from pyams_default_theme.component.illustration.portlet.interfaces import \
    IIllustrationPortletDefaultRendererSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config


@factory_config(IIllustrationPortletDefaultRendererSettings)
class IllustrationPortletDefaultRendererSettings(Persistent, Contained):
    """Illustration portlet default renderer settings"""

    show_border = FieldProperty(IIllustrationPortletDefaultRendererSettings['show_border'])


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IIllustrationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/illustration.pt', layer=IPyAMSLayer)
class IllustrationPortletDefaultRenderer(PortletRenderer):
    """Illustration portlet default renderer"""

    label = _("Default illustration renderer")

    settings_interface = IIllustrationPortletDefaultRendererSettings

    @property
    def illustration(self):
        for illustration in (
                self.request.registry.queryMultiAdapter((self.context, self.request, self.view),
                                                        IIllustrationPortletContent),
                IIllustration(self.context, None)):
            if (illustration is not None) and \
                    illustration.has_data() and \
                    (illustration.renderer != HIDDEN_RENDERER_NAME):
                return illustration
        return None
