#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces

# import packages
from zope.interface import Interface, Attribute
from zope.schema import Bool, Choice

from pyams_default_theme import _


ILLUSTRATION_BEFORE_TITLE = 'before-title'
ILLUSTRATION_BEFORE_BODY = 'before-body'
ILLUSTRATION_AFTER_BODY = 'after-body'


class IIllustrationRenderer(Interface):
    """Illustration renderer interface"""

    position = Attribute("Illustration position related to it's attached content")


class IIllustrationWithZoomSettings(Interface):
    """Illustration with zoom interface"""

    zoom_on_click = Bool(title=_("Zoom on click?"),
                         description=_("If 'yes', a click on illustration thumbnail is "
                                       "required to zoom"),
                         required=True,
                         default=True)
