#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.gallery.interfaces import IBaseGallery
from pyams_content.component.gallery.portlet.interfaces import IGalleryPortletSettings
from pyams_default_theme.component.gallery.interfaces import IGalleryDefaultRendererSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'

from pyams_default_theme import _, lightbox


class GalleryPortletBaseRenderer(PortletRenderer):
    """Gallery portlet default renderer"""

    def get_medias(self):
        gallery = IBaseGallery(self.context, None)
        if gallery is not None:
            yield from gallery.get_visible_medias()

    def get_images(self):
        gallery = IBaseGallery(self.context, None)
        if gallery is not None:
            yield from gallery.get_visible_images()


#
# Gallery mosaic portlet renderer
#

@factory_config(provided=IGalleryDefaultRendererSettings)
class GalleryPortletRendererSettings(Persistent, Contained):
    """Gallery mosaic portlet renderer settings"""

    thumbnails_selection = FieldProperty(IGalleryDefaultRendererSettings['thumbnails_selection'])


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IGalleryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/gallery.pt', layer=IPyAMSLayer)
class GalleryPortletDefaultRenderer(GalleryPortletBaseRenderer):
    """Gallery portlet default renderer"""

    label = _("Default gallery portlet")

    settings_interface = IGalleryDefaultRendererSettings
    resources = (lightbox,)
