#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Choice
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm

from pyams_default_theme import _


GALLERY_THUMBNAILS = (
    {'id': '', 'title': _("Device selection")},
    {'id': 'pano', 'title': _("Panoramic selection")},
    {'id': 'portrait', 'title': _("Portrait selection")},
    {'id': 'square', 'title': _("Square selection")}
)

GALLERY_THUMBNAILS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                                  for item in GALLERY_THUMBNAILS])


class IGalleryDefaultRendererSettings(Interface):
    """Gallery default renderer settings"""

    thumbnails_selection = Choice(title=_("Thumbnails selection"),
                                  description=_("Selection used to display images thumbnails"),
                                  vocabulary=GALLERY_THUMBNAILS_VOCABULARY,
                                  required=False,
                                  default='')
