#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.gallery.interfaces import IBaseGallery
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme import _, lightbox
from pyams_default_theme.component.gallery.interfaces import IGalleryDefaultRendererSettings
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


#
# Gallery default renderer settings
#

DEFAULT_GALLERY_RENDERER_SETTINGS_KEY = 'pyams_content.gallery.renderer:default'


@factory_config(IGalleryDefaultRendererSettings)
class GalleryDefaultRendererSettings(Persistent, Contained):
    """Gallery default renderer settings"""

    thumbnails_selection = FieldProperty(IGalleryDefaultRendererSettings['thumbnails_selection'])


@adapter_config(context=IBaseGallery, provides=IGalleryDefaultRendererSettings)
def default_gallery_renderer_settings_factory(context):
    """Gallery default renderer settings factory"""
    return get_annotation_adapter(context, DEFAULT_GALLERY_RENDERER_SETTINGS_KEY,
                                  IGalleryDefaultRendererSettings)


#
# Gallery default renderer
#

class BaseGalleryRenderer(BaseContentRenderer):
    """Base gallery renderer"""


@adapter_config(name='default', context=(IBaseGallery, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/renderer-default.pt', layer=IPyAMSLayer)
class DefaultGalleryRenderer(BaseGalleryRenderer):
    """Default gallery renderer"""

    label = _("Default grid gallery renderer")
    weight = 1

    i18n_context_attrs = ('title',)
    resources = (lightbox,)

    settings_interface = IGalleryDefaultRendererSettings


#
# Gallery carousel renderer
#

@adapter_config(name='carousel-sm', context=(IBaseGallery, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/renderer-carousel.pt', layer=IPyAMSLayer)
class CarouselGalleryRenderer(BaseGalleryRenderer):
    """Carousel gallery renderer"""

    label = _("Carousel gallery renderer")
    weight = 2

    i18n_context_attrs = ('title',)
