#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Int

__docformat__ = 'restructuredtext'

from pyams_default_theme import _


class IViewItemsPortletCalendarListRendererSettings(Interface):
    """View items portlet calendar list renderer settings interface"""

    previous_months = Int(title=_("Previous months"),
                          description=_("Number of previous months to extract events from"),
                          required=True,
                          default=0)

    displayed_months = Int(title=_("Displayed months"),
                           description=_("Number of months to extract events from"),
                           required=True,
                           default=3)
