#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Bool, Choice, Int, Set

from pyams_content.component.paragraph.interfaces import PARAGRAPH_FACTORIES_VOCABULARY
from pyams_default_theme import _
from pyams_utils.text import PYAMS_HTML_RENDERERS_VOCABULARY


class IAssociationParagraphDefaultRendererSettings(Interface):
    """Associations paragraph default renderer settings interface"""

    description_format = Choice(title=_("Description format"),
                                description=_("Formatting style used for description in associations"),
                                vocabulary=PYAMS_HTML_RENDERERS_VOCABULARY,
                                required=True,
                                default='text')


class IBaseAssociationParagraphRemoteContentRendererSettings(Interface):
    """Associations paragraph remote content renderer settings interface"""

    display_title = Bool(title=_("Display title?"),
                         description=_("Choose 'yes' to display remote content's title"),
                         required=True,
                         default=False)

    display_header = Bool(title=_("Display header?"),
                          description=_("Choose 'yes' to display remote content's header"),
                          required=True,
                          default=False)


class IAssociationParagraphSlicedRemoteContentRendererSettings(IBaseAssociationParagraphRemoteContentRendererSettings):
    """Associations paragraph renderer settings interface"""

    paragraphs_count = Int(title=_("Paragraphs count"),
                           description=_("Number of paragraphs used for each remote content "
                                         "(default=1)"),
                           required=False,
                           default=1)


class IAssociationParagraphRemoteContentRendererSettings(IBaseAssociationParagraphRemoteContentRendererSettings):
    """Associations paragraph remote content renderer settings interface"""

    factories = Set(title=_("Paragraph types"),
                    description=_("Select list of paragraph types you want to include; an empty "
                                  "selection means that all paragraphs will be selected"),
                    required=False,
                    value_type=Choice(vocabulary=PARAGRAPH_FACTORIES_VOCABULARY))

    anchors_only = Bool(title=_("Anchors only?"),
                        description=_("If 'yes', only paragraphs set as 'anchors' will be "
                                      "selected"),
                        required=True,
                        default=False)
