#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from fanstatic import Library, Resource
from pyramid.i18n import TranslationStringFactory

from myams import bootstrap, bootstrap_css, bootstrap_modal_css, myams_js_require
from pyams_utils.fanstatic import ExternalResource


_ = TranslationStringFactory('pyams_default_theme')


library = Library('pyams_default_theme', 'resources')

pyams_default_theme_fonts = ExternalResource(library,
                                             'https://fonts.googleapis.com/css?family=Lato:300|Oswald|Source+Code+Pro',
                                             resource_type='css')

pyams_default_theme_css = Resource(library, 'css/pyams-default.css',
                                   minified='css/pyams-default.min.css',
                                   depends=(bootstrap_css, pyams_default_theme_fonts))

pyams_default_theme = Resource(library, 'js/pyams-default.js',
                               minified='js/pyams-default.min.js',
                               depends=(bootstrap, myams_js_require, pyams_default_theme_css),
                               bottom=True)

#
# External extensions
#

lightbox_css = Resource(library, 'css/ext/ekko-lightbox.css',
                        minified='css/ext/ekko-lightbox.min.css',
                        depends=(bootstrap_modal_css,))

lightbox = Resource(library, 'js/ext/ekko-lightbox.js',
                    minified='js/ext/ekko-lightbox.min.js',
                    depends=(bootstrap, lightbox_css),
                    bottom=True)


def includeme(config):
    """Pyramid include"""

    from .include import include_package
    include_package(config)
