#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary
from pyams_workflow.interfaces import IWorkflow

from pyams_content import _


class IContentWorkflow(IWorkflow):
    """PyAMS default content workflow marker interface"""


class IBasicWorkflow(IWorkflow):
    """PyAMS basic workflow marker interface"""


class IAlertsWorkflow(IBasicWorkflow):
    """PyAMS alerts workflow marker interface"""


#
# Workflow states
#

DRAFT = 'draft'
PROPOSED = 'proposed'
CANCELED = 'canceled'
REFUSED = 'refused'
PRE_PUBLISHED = 'pre-published'
PUBLISHED = 'published'
RETIRING = 'retiring'
RETIRED = 'retired'
ARCHIVING = 'archiving'
ARCHIVED = 'archived'
DELETED = 'deleted'

STATES_IDS = (DRAFT,
              PROPOSED,
              CANCELED,
              REFUSED,
              PRE_PUBLISHED,
              PUBLISHED,
              RETIRING,
              RETIRED,
              ARCHIVING,
              ARCHIVED,
              DELETED)

STATES_LABELS = (_("Draft"),
                 _("Proposed"),
                 _("Canceled"),
                 _("Refused"),
                 _("Published (waiting)"),
                 _("Published"),
                 _("Retiring"),
                 _("Retired"),
                 _("Archiving"),
                 _("Archived"),
                 _("Deleted"))

STATES_VOCABULARY = SimpleVocabulary([SimpleTerm(STATES_IDS[i], title=t)
                                      for i, t in enumerate(STATES_LABELS)])

STATES_HEADERS = {
    DRAFT: _("draft created"),
    PROPOSED: _("publication requested"),
    PRE_PUBLISHED: _("published (waiting)"),
    PUBLISHED: _("published"),
    RETIRING: _("retiring requested"),
    RETIRED: _("retired"),
    ARCHIVING: _("archiving requested"),
    ARCHIVED: _("archived")
}

UPDATE_STATES = (DRAFT, )
'''Default state available to contributors in update mode'''

READONLY_STATES = (RETIRED, ARCHIVING, ARCHIVED, DELETED)
'''Retired and archived contents can't be modified'''

PROTECTED_STATES = (PRE_PUBLISHED, PUBLISHED, RETIRING)
'''Protected states are available to webmasters in update mode'''

MANAGER_STATES = (PROPOSED, )
'''Only managers can update proposed contents (if their restrictions apply)'''

PUBLISHED_STATES = (PRE_PUBLISHED, PUBLISHED, RETIRING)

VISIBLE_STATES = (PUBLISHED, RETIRING)

WAITING_STATES = (PROPOSED, RETIRING, ARCHIVING)

RETIRED_STATES = (RETIRED, ARCHIVING)

ARCHIVED_STATES = (ARCHIVED, )
