#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import button, field
from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
from z3c.form.interfaces import INPUT_MODE
from zope.interface import Interface, implementer

from pyams_content.component.theme import ICollectionsManager, ITagsManager, IThemesManager
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.view.interfaces import IViewCollectionsSettings, IViewTagsSettings, \
    IViewThemesSettings, IViewsManager, IWfView
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IUncheckedEditFormButtons, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_thesaurus.zmi.widget import ThesaurusTermsTreeFieldWidget
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_utils.registry import get_utility
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from pyams_content import _


#
# Tags management
#

@viewlet_config(name='tags.menu', context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=350)
class ViewTagsMenu(MenuItem):
    """View tags menu"""

    label = _("Tags...")
    icon_class = 'fa-tag'
    url = '#tags.html'


@pagelet_config(name='tags.html', context=IWfView, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='tags.json', context=IWfView, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class ViewTagsEditForm(AdminEditForm):
    """View tags settings edit form"""

    legend = _("View tags settings")
    label_css_class = 'control-label col-md-1'
    input_css_class = 'col-md-11'

    fields = field.Fields(IViewTagsSettings)
    fields['select_context_tags'].widgetFactory = SingleCheckBoxFieldWidget
    fields['tags'].widgetFactory = ThesaurusTermsTreeFieldWidget

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        else:
            return button.Buttons(Interface)

    def updateWidgets(self, prefix=None):
        super(ViewTagsEditForm, self).updateWidgets(prefix)
        if 'tags' in self.widgets:
            manager = ITagsManager(self.request.root)
            widget = self.widgets['tags']
            widget.label_css_class = 'control-label col-md-2'
            widget.input_css_class = 'col-md-12'
            widget.thesaurus_name = manager.thesaurus_name
            widget.extract_name = manager.extract_name


#
# Themes management
#

@viewlet_config(name='themes.menu', context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=360)
class ViewThemesMenu(MenuItem):
    """View themes menu"""

    label = _("Themes...")
    icon_class = 'fa-tags'
    url = '#themes.html'


@pagelet_config(name='themes.html', context=IWfView, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='themes.json', context=IWfView, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class ViewThemesEditForm(AdminEditForm):
    """View themes settings edit form"""

    legend = _("View themes settings")
    label_css_class = 'control-label col-md-1'
    input_css_class = 'col-md-11'

    fields = field.Fields(IViewThemesSettings)
    fields['select_context_themes'].widgetFactory = SingleCheckBoxFieldWidget
    fields['themes'].widgetFactory = ThesaurusTermsTreeFieldWidget
    fields['include_subthemes'].widgetFactory = SingleCheckBoxFieldWidget

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        else:
            return button.Buttons(Interface)

    def updateWidgets(self, prefix=None):
        super(ViewThemesEditForm, self).updateWidgets(prefix)
        if 'themes' in self.widgets:
            manager = IThemesManager(get_utility(IViewsManager))
            widget = self.widgets['themes']
            widget.label_css_class = 'control-label col-md-2'
            widget.input_css_class = 'col-md-12'
            widget.thesaurus_name = manager.thesaurus_name
            widget.extract_name = manager.extract_name


#
# Collections management
#

@viewlet_config(name='collections.menu', context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=370)
class ViewCollectionsMenu(MenuItem):
    """View collections menu"""

    label = _("Collections...")
    icon_class = 'fa-book'
    url = '#collections.html'


@pagelet_config(name='collections.html', context=IWfView, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='collections.json', context=IWfView, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class ViewCollectionsEditForm(AdminEditForm):
    """View collections settings edit form"""

    legend = _("View collections settings")
    label_css_class = 'control-label col-md-1'
    input_css_class = 'col-md-11'

    fields = field.Fields(IViewCollectionsSettings)
    fields['select_context_collections'].widgetFactory = SingleCheckBoxFieldWidget
    fields['collections'].widgetFactory = ThesaurusTermsTreeFieldWidget

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        else:
            return button.Buttons(Interface)

    def updateWidgets(self, prefix=None):
        super(ViewCollectionsEditForm, self).updateWidgets(prefix)
        if 'collections' in self.widgets:
            manager = ICollectionsManager(get_utility(IViewsManager))
            widget = self.widgets['collections']
            widget.label_css_class = 'control-label col-md-2'
            widget.input_css_class = 'col-md-12'
            widget.thesaurus_name = manager.thesaurus_name
            widget.extract_name = manager.extract_name
