#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import button, field
from z3c.form.interfaces import INPUT_MODE
from zope.interface import Interface, implementer

from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.view.interfaces import IViewInternalReferencesSettings, IWfView
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IUncheckedEditFormButtons, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuDivider, MenuItem
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

__docformat__ = 'restructuredtext'

from pyams_content import _


@viewlet_config(name='references.divider', context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=299)
class ViewReferencesMenuDivider(MenuDivider):
    """View references menu divider"""


@viewlet_config(name='references.menu', context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=300)
class ViewReferencesMenu(MenuItem):
    """View references menu"""

    label = _("References...")
    icon_class = 'fa-external-link-square fa-rotate-90'
    url = '#references.html'


@pagelet_config(name='references.html', context=IWfView, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='references.json', context=IWfView, layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class ViewReferencesEditForm(AdminEditForm):
    """View references settings edit form"""

    legend = _("View internal references settings")

    fields = field.Fields(IViewInternalReferencesSettings)

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        else:
            return button.Buttons(Interface)
