#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import json

from z3c.form import field
from zope.interface import alsoProvides

from pyams_content.shared.common.types import get_all_data_types
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_content.shared.view.interfaces import IWfView
from pyams_form.help import FormHelp
from pyams_form.interfaces.form import IFormHelp, IInnerSubForm
from pyams_form.widget import HiddenSelect2FieldWidget
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.data import IObjectData
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.layer import IAdminLayer

from pyams_content import _


@adapter_config(name='view-settings',
                context=(IWfView, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class ViewPropertiesEditForm(InnerAdminEditForm):
    """View properties edit form extension"""

    prefix = 'view_settings.'

    legend = _("Main view settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IWfView).select('select_context_path', 'select_context_type',
                                          'selected_content_types', 'select_context_datatype',
                                          'selected_datatypes', 'excluded_content_types',
                                          'excluded_datatypes', 'order_by', 'reversed_order',
                                          'limit', 'age_limit')
    fields['selected_datatypes'].widgetFactory = HiddenSelect2FieldWidget
    fields['excluded_datatypes'].widgetFactory = HiddenSelect2FieldWidget

    weight = 1

    def updateWidgets(self, prefix=None):
        super(ViewPropertiesEditForm, self).updateWidgets(prefix)
        data_types = get_all_data_types(self.request)
        if 'selected_datatypes' in self.widgets:
            widget = self.widgets['selected_datatypes']
            widget.object_data = {
                'ams-select2-multiple': True,
                'ams-select2-data': json.dumps(data_types)
            }
            alsoProvides(widget, IObjectData)
        if 'excluded_datatypes' in self.widgets:
            widget = self.widgets['excluded_datatypes']
            widget.object_data = {
                'ams-select2-multiple': True,
                'ams-select2-data': json.dumps(data_types)
            }
            alsoProvides(widget, IObjectData)


@adapter_config(context=(IWfView, IAdminLayer, ViewPropertiesEditForm), provides=IFormHelp)
class ViewPropertiesFormHelp(FormHelp):
    """View properties form help"""

    message = _("""These settings apply to search made by the view.

If you select the option "Include ONLY selected references", via the "References" menu, only 
selected references will be selected (if published) and no real search will be made !

In other modes, and if no search criteria is defined (in this form, or in other settings forms), ALL
published contents will be selected by the view !!
""")
    message_format = 'rest'
