#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.view.interfaces import IWfView, IViewsManager
from pyams_i18n.interfaces import II18n
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_content.shared.common.zmi import SharedContentAddForm, SharedContentAJAXAddForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import adapter_config, ContextRequestAdapter, ContextRequestViewAdapter
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyramid.view import view_config
from zope.interface import Interface

from pyams_content import _


@adapter_config(context=(IWfView, IContentManagementMenu), provides=IMenuHeader)
class ViewContentMenuHeader(ContextRequestAdapter):
    """View menu header adapter"""

    header = _("This view")


@adapter_config(context=(IWfView, IPyAMSLayer, Interface), provides=IContentTitle)
class ViewTitleAdapter(ContextRequestViewAdapter):
    """View title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("View « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=IViewsManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class ViewAddAction(ToolbarAction):
    """View adding action"""

    label = _("Add view")
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=IViewsManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class ViewAddForm(SharedContentAddForm):
    """View add form"""

    legend = _("Add view")


@view_config(name='add-shared-content.json', context=IViewsManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, renderer='json', xhr=True)
class ViewAJAXAddForm(SharedContentAJAXAddForm, ViewAddForm):
    """View add form, JSON renderer"""
