#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.theme.interfaces import IThemesManagerTarget, ICollectionsManagerTarget
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.view.interfaces import IViewsManager, VIEW_CONTENT_TYPE, IViewsManagerFactory
from zope.annotation.interfaces import IAttributeAnnotatable
from zope.component.interfaces import ISite
from zope.lifecycleevent.interfaces import IObjectAddedEvent

# import packages
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.view import View
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent
from pyramid.events import subscriber
from zope.interface import implementer


@implementer(IViewsManager, IThemesManagerTarget, ICollectionsManagerTarget, IAttributeAnnotatable)
class ViewsManager(SharedTool):
    """Views manager class"""

    shared_content_type = VIEW_CONTENT_TYPE
    shared_content_menu = False


@utility_config(provides=IViewsManagerFactory)
class ViewsManagerFactory(object):
    """Default views manager factory"""

    def __new__(cls):
        return ViewsManager


@adapter_config(context=IViewsManager, provides=ISharedContentFactory)
def views_manager_content_factory(context):
    """Views manager content factory"""
    return View


@subscriber(IObjectAddedEvent, context_selector=IViewsManager)
def handle_added_views_manager(event):
    """Register views manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IViewsManager)
