#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from pyams_content.shared.common import IWfSharedContent
from pyams_content.shared.common.zmi.summary import SharedContentSummaryForm
from pyams_content.shared.common.zmi.types.summary import TypedSharedContentDublinCoreSummary
from pyams_content.shared.topic import IWfTopic
from pyams_form.interfaces.form import IInnerSubForm
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@adapter_config(name='dublincore-summary',
                context=(IWfTopic, IPyAMSLayer, SharedContentSummaryForm),
                provides=IInnerSubForm)
class TopicDublinCoreSummary(TypedSharedContentDublinCoreSummary):
    """Topic DublinCore summary"""

    @property
    def fields(self):
        fields = field.Fields(IWfSharedContent).select('title') + \
                 field.Fields(IWfTopic).select('data_type') + \
                 field.Fields(ISequentialIdInfo).select('public_oid')
        return fields
