#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm
from pyams_content.shared.common.zmi.types import TypedSharedContentAddForm, TypedSharedContentTypeFieldsEditForm
from pyams_content.shared.resource import IWfResource
from pyams_content.shared.resource.interfaces import IResourceManager
from pyams_form.form import ajax_config
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu, IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

from pyams_content import _


@adapter_config(context=(IWfResource, IContentManagementMenu), provides=IMenuHeader)
class ResourceContentMenuHeader(ContextRequestAdapter):
    """Resource content menu header adapter"""

    header = _("This resource")


@adapter_config(context=(IWfResource, IPyAMSLayer, Interface), provides=IContentTitle)
class ResourceTitleAdapter(ContextRequestViewAdapter):
    """Resource title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Resource « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=IResourceManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class ResourceAddAction(ToolbarAction):
    """Resource adding action"""

    label = _("Add resource")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=IResourceManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json', context=IResourceManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, base=SharedContentAJAXAddForm)
class ResourceAddForm(TypedSharedContentAddForm):
    """Resource add form"""

    legend = _("Add resource")


#
# Resource info edit form
#

@viewlet_config(name='custom-properties.menu', context=IWfResource, layer=IPyAMSLayer,
                manager=IPropertiesMenu, permission=MANAGE_CONTENT_PERMISSION, weight=20)
class ResourceTypePropertiesMenu(MenuItem):
    """Resource type properties menu"""

    label = _("Specific properties")
    icon_class = 'fa-paperclip'
    url = '#type-properties.html'


@pagelet_config(name='type-properties.html', context=IWfResource, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='type-properties.json', context=IWfResource, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class ResourceTypePropertiesEditForm(TypedSharedContentTypeFieldsEditForm):
    """Resource type properties edit form"""
