#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.news.interfaces import INewsManager, IWfNewsEvent
from pyams_i18n.interfaces import II18n
from pyams_skin.interfaces.viewlet import IWidgetTitleViewletManager, IMenuHeader
from pyams_skin.layer import IPyAMSLayer
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_content.shared.common.zmi import SharedContentAddForm, SharedContentAJAXAddForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter, ContextRequestAdapter
from pyams_viewlet.viewlet import viewlet_config
from pyramid.view import view_config
from zope.interface import Interface

from pyams_content import _


@adapter_config(context=(IWfNewsEvent, IContentManagementMenu), provides=IMenuHeader)
class NewsEventContentMenuHeader(ContextRequestAdapter):
    """News event content menu header adapter"""

    header = _("This news topic")


@adapter_config(context=(IWfNewsEvent, IPyAMSLayer, Interface), provides=IContentTitle)
class NewsEventTitleAdapter(ContextRequestViewAdapter):
    """News event title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("News topic « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=INewsManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class NewsEventAddAction(ToolbarAction):
    """News event adding action"""

    label = _("Add news topic")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=INewsManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class NewsEventAddForm(SharedContentAddForm):
    """News event add form"""

    legend = _("Add news topic")


@view_config(name='add-shared-content.json', context=INewsManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, renderer='json', xhr=True)
class NewsEventAJAXAddForm(SharedContentAJAXAddForm, NewsEventAddForm):
    """News event add form, JSON renderer"""
