#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.paragraph.interfaces import IParagraphFactorySettings
from pyams_content.component.theme.interfaces import IThemesManagerTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.news import NewsEvent
from pyams_content.shared.news.interfaces import INewsManager, INewsManagerFactory, \
    NEWS_CONTENT_TYPE
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


__docformat__ = 'restructuredtext'


@implementer(INewsManager, IParagraphFactorySettings, IThemesManagerTarget, IPictogramManagerTarget)
class NewsManager(SharedTool):
    """News manager class"""

    shared_content_type = NEWS_CONTENT_TYPE

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])


@utility_config(provides=INewsManagerFactory)
class NewsManagerFactory:
    """Default news manager factory"""

    def __new__(cls):
        return NewsManager


@adapter_config(context=INewsManager, provides=ISharedContentFactory)
def news_manager_content_factory(context):
    return NewsEvent


@subscriber(IObjectAddedEvent, context_selector=INewsManager)
def handle_added_news_manager(event):
    """Register news manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, INewsManager)
