#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration.interfaces import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.news.interfaces import INewsEvent, IWfNewsEvent, IWfNewsEventFactory, NEWS_CONTENT_NAME, \
    NEWS_CONTENT_TYPE
from pyams_utils.adapter import adapter_config


@implementer(IWfNewsEvent, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfNewsEvent(WfSharedContent):
    """Base news event"""

    content_type = NEWS_CONTENT_TYPE
    content_name = NEWS_CONTENT_NAME

    references = FieldProperty(IWfNewsEvent['references'])

register_content_type(WfNewsEvent)


@provider(IWfNewsEventFactory)
@implementer(INewsEvent)
class NewsEvent(SharedContent):
    """Workflow managed news event class"""


@adapter_config(context=IWfNewsEventFactory, provides=IWfSharedContentFactory)
def news_event_content_factory(context):
    return WfNewsEvent
