#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field

from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_content.shared.common.zmi.summary import SharedContentDublinCoreSummary, SharedContentSummaryForm
from pyams_content.shared.logo import IWfLogo
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.form import InnerAdminEditForm

from pyams_content import _


@adapter_config(name='dublincore-summary',
                context=(IWfLogo, IPyAMSLayer, SharedContentSummaryForm),
                provides=IInnerSubForm)
class LogoDublinCoreSummary(SharedContentDublinCoreSummary):
    """Shared content DublinCore summary"""

    fields = field.Fields(IWfLogo).select('title', 'acronym') + \
        field.Fields(ISequentialIdInfo).select('public_oid')


@pagelet_config(name='properties.html', context=IWfLogo, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=IWfLogo, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class LogoMainPropertiesEditForm(SharedContentPropertiesEditForm):
    """Logo properties edit form"""

    interface = IWfLogo
    fieldnames = ('title', 'short_name', 'notepad')


@adapter_config(name='logo-settings',
                context=(IWfLogo, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class LogoPropertiesEditForm(InnerAdminEditForm):
    """Logo properties edit form extension"""

    prefix = 'logo_settings.'

    legend = _("Main logo settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IWfLogo).select('acronym', 'url', 'reference', 'alt_title',
                                          'image', 'monochrome_image')
    weight = 1

    def get_ajax_output(self, changes):
        if changes:
            return {
                'status': 'reload',
                'message': self.request.localizer.translate(self.successMessage)
            }
        return super(LogoPropertiesEditForm, self).get_ajax_output(changes)
