#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.logo.interfaces import ILogosManager, ILogosManagerFactory
from zope.annotation import IAttributeAnnotatable
from zope.component.interfaces import ISite
from zope.lifecycleevent import IObjectAddedEvent

# import packages
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.logo import LOGO_CONTENT_TYPE, Logo
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent
from pyramid.events import subscriber
from zope.interface import implementer


@implementer(ILogosManager, IAttributeAnnotatable)
class LogosManager(SharedTool):
    """Logos manager class"""

    shared_content_type = LOGO_CONTENT_TYPE
    shared_content_menu = False


@utility_config(provides=ILogosManagerFactory)
class LogosManagerFactory(object):
    """Default logos manager factory"""

    def __new__(cls):
        return LogosManager


@adapter_config(context=ILogosManager, provides=ISharedContentFactory)
def logos_manager_content_factory(context):
    """Logos manager content factory"""
    return Logo


@subscriber(IObjectAddedEvent, context_selector=ILogosManager)
def handle_added_logos_manager(event):
    """Register logos manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, ILogosManager)
