#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.imagemap.interfaces import IWfImageMap
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from z3c.form import field

from pyams_content import _


@adapter_config(name='image',
                context=(IWfImageMap, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class ImageMapPropertiesEditForm(InnerAdminEditForm):
    """Image map properties edit form extension"""

    prefix = 'imagemap.'

    legend = _("Background image")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IWfImageMap).select('image')

    weight = 10

    def get_ajax_output(self, changes):
        if 'image' in changes.get(IWfImageMap, ()):
            translate = self.request.localizer.translate
            return {
                'status': 'reload',
                'message': translate(self.successMessage)
            }
