#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.imagemap.interfaces import IImageMapManager, IMAGEMAP_CONTENT_TYPE, IImageMapManagerFactory
from zope.annotation.interfaces import IAttributeAnnotatable
from zope.lifecycleevent.interfaces import IObjectAddedEvent

# import packages
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.imagemap import ImageMap
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent
from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer


@implementer(IImageMapManager, IAttributeAnnotatable)
class ImageMapsManager(SharedTool):
    """Image maps manager class"""

    shared_content_type = IMAGEMAP_CONTENT_TYPE
    shared_content_menu = False


@utility_config(provides=IImageMapManagerFactory)
class ImageMapsManagerFactory(object):
    """Default image maps manager factory"""

    def __new__(cls):
        return ImageMapsManager


@adapter_config(context=IImageMapManager, provides=ISharedContentFactory)
def image_maps_manager_content_factory(context):
    return ImageMap


@subscriber(IObjectAddedEvent, context_selector=IImageMapManager)
def handle_added_imagemaps_manager(event):
    """Register image maps manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IImageMapManager)
