#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_content.shared.common.interfaces import ISharedTool, IWfSharedContent, ISharedContent
from pyams_sequence.interfaces import IInternalReference
from zope.annotation.interfaces import IAttributeAnnotatable

# import packages
from pyams_content.shared.imagemap.schema import MapArea
from pyams_i18n.schema import I18nTextLineField, I18nImageField
from pyams_sequence.schema import InternalReferenceField
from pyams_utils.schema import PersistentDict
from zope.interface import Interface
from zope.schema import Object, Choice

from pyams_content import _


IMAGEMAP_CONTENT_TYPE = 'imagemap'
IMAGEMAP_CONTENT_NAME = _("Image map")


class IImageMapManager(ISharedTool):
    """Image maps manager interface"""


class IImageMapManagerFactory(Interface):
    """Image maps manager factory interface"""


class IImageMapArea(IAttributeAnnotatable):
    """Image map area interface"""

    link = Choice(title=_("Link target"),
                  description=_("Internal or external link associated with this map area"),
                  vocabulary="PyAMS content associations",
                  required=True)

    title = I18nTextLineField(title=_("Alternate title"),
                              description=_("Alternate label associated with this area"),
                              required=False)

    area = MapArea(title=_("Map area coordinates"),
                   description=_("List of coordinates of image area"),
                   required=True)


class IWfImageMap(IWfSharedContent):
    """Image map interface"""

    image = I18nImageField(title=_("Image"),
                           description=_("Image supporting map areas"),
                           required=True)

    areas = PersistentDict(title=_("Image map areas"),
                           description=_("List of defined map areas"),
                           value_type=Object(schema=IImageMapArea),
                           required=False)

    def get_association(self, area):
        """Get association for given area"""


class IWfImageMapFactory(Interface):
    """Image map factory interface"""


class IImageMap(ISharedContent):
    """Workflow managed image map interface"""


IMAGEMAP_PARAGRAPH_TYPE = 'ImageMap'
IMAGEMAP_PARAGRAPH_NAME = _("Image map")
IMAGEMAP_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.imagemap.renderers'


class IImageMapParagraph(IBaseParagraph, IInternalReference):
    """Image map paragraph"""

    reference = InternalReferenceField(title=_("Internal reference"),
                                       description=_("Reference to image map object"),
                                       content_type=IMAGEMAP_CONTENT_TYPE)

    renderer = Choice(title=_("Image map template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=IMAGEMAP_PARAGRAPH_RENDERERS,
                      default='default')
