#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.container.ordered import OrderedContainer
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph import IParagraphContainerTarget
from pyams_content.component.paragraph.interfaces import IParagraphFactorySettings
from pyams_content.component.theme import ITagsTarget, IThemesTarget
from pyams_content.component.theme.interfaces import ICollectionsManagerTarget, \
    IThemesManagerTarget
from pyams_content.features.footer.interfaces import IFooterTarget
from pyams_content.features.header.interfaces import IHeaderTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.root.interfaces import ISiteRoot
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.common.manager import BaseSharedTool
from pyams_content.shared.common.types import TypedSharedToolMixin
from pyams_content.shared.hub.interfaces import IHubManager, IHubManagerFactory
from pyams_content.shared.site.container import SiteContainerMixin
from pyams_content.shared.site.folder import SiteFolder
from pyams_content.shared.site.interfaces import ISiteFolderFactory
from pyams_portal.interfaces import IPortalContext
from pyams_skin.skin import UserSkinnableContent
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from pyams_content import _


@implementer(IHubManager, IParagraphFactorySettings, IParagraphContainerTarget,
             IThemesManagerTarget, IPictogramManagerTarget, ITagsTarget, IThemesTarget,
             IIllustrationTarget, ILinkIllustrationTarget, IPortalContext, IHeaderTarget,
             IFooterTarget, IPreviewTarget)
class HubManager(SiteContainerMixin, OrderedContainer, BaseSharedTool, TypedSharedToolMixin,
                 UserSkinnableContent):
    """Hub manager persistent class"""

    header = FieldProperty(IHubManager['header'])
    navigation_header = FieldProperty(IHubManager['navigation_header'])
    description = FieldProperty(IHubManager['description'])
    notepad = FieldProperty(IHubManager['notepad'])
    navigation_mode = FieldProperty(IHubManager['navigation_mode'])
    indexation_mode = FieldProperty(IHubManager['indexation_mode'])

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])

    sequence_name = ''  # use default sequence generator
    sequence_prefix = ''

    content_name = _("Hub manager")

    @property
    def folder_factory(self):
        return ISiteFolderFactory(self, SiteFolder)

    @property
    def topic_content_factory(self):
        return ISharedContentFactory(self, None)

    @property
    def topic_content_type(self):
        factory = self.topic_content_factory
        if factory is not None:
            return factory.content_class.content_type

    def is_deletable(self):
        for element in self.values():
            if not element.is_deletable():
                return False
        return True


@adapter_config(context=ISiteRoot, provides=IHubManagerFactory)
def site_root_hub_manager_factory(context):
    return HubManager


@adapter_config(context=IHubManager, provides=ISiteFolderFactory)
def hub_manager_folder_factory(context):
    return SiteFolder
