#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.shared.site.interfaces import ISiteManager
from pyams_i18n.schema import I18nTextField

__docformat__ = 'restructuredtext'

from pyams_content import _


class IHubManager(ISiteManager):
    """Hub manager interface"""

    navigation_header = I18nTextField(title=_("Navigation header"),
                                      description=_("Alternate content's header displayed in "
                                                    "navigation pages; original header will be "
                                                    "used if none is specified"),
                                      required=False)


class IHubManagerFactory(Interface):
    """Hub manager factory interface"""
