#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import button
from z3c.form.interfaces import INPUT_MODE
from zope.interface import implementer

from pyams_content.component.paragraph import IParagraphContainerTarget, IParagraphFactorySettings
from pyams_content.component.paragraph.zmi import IParagraphContainerView, BaseParagraphAddMenu, \
    BaseParagraphAJAXAddForm, BaseParagraphAddForm, BaseParagraphAJAXEditForm, \
    BaseParagraphPropertiesEditForm, IParagraphInnerEditFormButtons
from pyams_content.component.paragraph.zmi.interfaces import IParagraphInnerEditor
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.form import IWfForm
from pyams_content.shared.form.field import FormFieldsParagraph
from pyams_content.shared.form.interfaces import FORM_FIELDS_PARAGRAPH_TYPE, IFormFieldsParagraph
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerForm
from pyams_form.security import ProtectedFormObjectMixin
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces.viewlet import IToolbarAddingMenu
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuDivider
from pyams_utils.adapter import adapter_config
from pyams_utils.traversing import get_parent
from pyams_viewlet.viewlet import viewlet_config


__docformat__ = 'restructuredtext'

from pyams_content import _


@viewlet_config(name='add-form-fields-paragraph.divider', context=IParagraphContainerTarget,
                view=IParagraphContainerView, layer=IPyAMSLayer, manager=IToolbarAddingMenu,
                weight=899)
class FormFieldsParagraphAddMenuDivider(ProtectedFormObjectMixin, MenuDivider):
    """Form fields paragraph add menu divider"""

    def __new__(cls, context, request, view, manager):
        if not IWfForm.providedBy(context):
            return None
        settings = get_parent(context, IParagraphFactorySettings)
        if (settings is not None) and (
                FORM_FIELDS_PARAGRAPH_TYPE not in (settings.allowed_paragraphs or ())):
            return None
        return MenuDivider.__new__(cls)


@viewlet_config(name='add-form-fields-paragraph.menu', context=IParagraphContainerTarget,
                view=IParagraphContainerView, layer=IPyAMSLayer, manager=IToolbarAddingMenu,
                weight=900)
class FormFieldsParagraphAddMenu(BaseParagraphAddMenu):
    """Form fields paragraph add menu"""

    label = _("Form: input fields...")
    label_css_class = 'fa fa-fw ' + FormFieldsParagraph.icon_class
    url = 'add-form-fields-paragraph.html'
    paragraph_type = FORM_FIELDS_PARAGRAPH_TYPE

    def __new__(cls, context, request, view, manager):
        if not IWfForm.providedBy(context):
            return None
        return BaseParagraphAddMenu.__new__(cls, context, request, view, manager)


@pagelet_config(name='add-form-fields-paragraph.html', context=IParagraphContainerTarget,
                layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='add-form-fields-paragraph.json', context=IParagraphContainerTarget,
             layer=IPyAMSLayer, base=BaseParagraphAJAXAddForm)
class FormFieldsParagraphAddForm(BaseParagraphAddForm):
    """Form fields paragraph add form"""

    legend = _("Add new form fields paragraph")

    content_interface = IFormFieldsParagraph


@pagelet_config(name='properties.html', context=IFormFieldsParagraph, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='properties.json', context=IFormFieldsParagraph, layer=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
class FormFieldsParagraphPropertiesEditForm(BaseParagraphPropertiesEditForm):
    """Form fields paragraph properties edit form"""

    prefix = 'form_fields_properties.'

    legend = _("Edit form fields paragraph properties")

    content_interface = IFormFieldsParagraph


@adapter_config(context=(IFormFieldsParagraph, IPyAMSLayer), provides=IParagraphInnerEditor)
@ajax_config(name='inner-properties.json', context=IFormFieldsParagraph, layer=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
@implementer(IInnerForm)
class FormFieldsParagraphInnerEditForm(FormFieldsParagraphPropertiesEditForm):
    """Form fields paragraph properties inner edit form"""

    legend = None

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IParagraphInnerEditFormButtons)
        else:
            return button.Buttons()
