#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.events import subscriber
from z3c.form import field
from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
from z3c.form.interfaces import IDataExtractedEvent
from zope.interface import Invalid

from pyams_content.shared.common.zmi.manager import SharedToolPropertiesEditForm
from pyams_content.shared.form.interfaces import IFormsManager
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm


__docformat__ = 'restructuredtext'

from pyams_content import _


@adapter_config(name='captcha-settings',
                context=(IFormsManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class FormManagerCaptchaSettingsEditForm(InnerAdminEditForm):
    """Form manager captcha settings edit form"""

    prefix = 'captcha_properties.'

    legend = _("Captcha settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IFormsManager).select('use_captcha',
                                                'default_captcha_client_key',
                                                'default_captcha_server_key',
                                                'use_proxy',
                                                'proxy_proto',
                                                'proxy_host',
                                                'proxy_port',
                                                'proxy_username',
                                                'proxy_password',
                                                'proxy_only_from')
    fields['use_captcha'].widgetFactory = SingleCheckBoxFieldWidget
    fields['use_proxy'].widgetFactory = SingleCheckBoxFieldWidget

    weight = 1

    def updateGroups(self):
        self.add_group(NamedWidgetsGroup(self, 'captcha', self.widgets,
                                         ('use_captcha', 'default_captcha_client_key',
                                          'default_captcha_server_key'),
                                         fieldset_class='inner bordered',
                                         legend=_("Use captcha"),
                                         css_class='inner',
                                         switch=True,
                                         checkbox_switch=True,
                                         checkbox_field=IFormsManager['use_captcha']))
        self.add_group(NamedWidgetsGroup(self, 'proxy', self.widgets,
                                         ('use_proxy', 'proxy_proto', 'proxy_host',
                                          'proxy_port', 'proxy_username', 'proxy_password',
                                          'proxy_only_from'),
                                         fieldset_class='inner bordered',
                                         legend=_("Use proxy server"),
                                         css_class='inner',
                                         switch=True,
                                         checkbox_switch=True,
                                         checkbox_field=IFormsManager['use_proxy']))
        super(FormManagerCaptchaSettingsEditForm, self).updateGroups()


@subscriber(IDataExtractedEvent, form_selector=FormManagerCaptchaSettingsEditForm)
def check_form_captcha_data(event):
    """Check captcha form input data"""
    data = event.data
    if data.get('use_captcha') and not (data.get('default_captcha_client_key') and
                                        data.get('default_captcha_server_key')):
        event.form.widgets.errors += (Invalid(_("You must define client and server key to "
                                                "activate a captcha")), )
    if data.get('use_proxy') and not data.get('proxy_host'):
        event.form.widgets.errors += (Invalid(_("You must define hostname to use a proxy")), )
