#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import button
from z3c.form.interfaces import INPUT_MODE
from zope.interface import implementer

from pyams_content.component.paragraph import BaseParagraphFactory, IParagraphContainerTarget
from pyams_content.component.paragraph.interfaces import IParagraphFactory
from pyams_content.component.paragraph.zmi import BaseParagraphAJAXAddForm, BaseParagraphAJAXEditForm, \
    BaseParagraphAddForm, BaseParagraphAddMenu, BaseParagraphPropertiesEditForm, IParagraphContainerView, \
    IParagraphInnerEditFormButtons
from pyams_content.component.paragraph.zmi.interfaces import IParagraphInnerEditor
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.interfaces.specificities import ISharedContentSpecificitiesParagraph
from pyams_content.shared.common.specificities import SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_NAME, \
    SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_TYPE, SharedContentSpecificitiesParagraph
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces.viewlet import IToolbarAddingMenu
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_viewlet.viewlet import viewlet_config

from pyams_content import _


#
# Shared content specificities paragraph views
#

@utility_config(name=SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_TYPE, provides=IParagraphFactory)
class SharedContentSpecificitiesParagraphFactory(BaseParagraphFactory):
    """Shared content specificities paragraph factory"""

    name = SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_NAME
    content_type = SharedContentSpecificitiesParagraph
    secondary_menu = True


@viewlet_config(name='add-specificities-paragraph.menu', context=IParagraphContainerTarget,
                view=IParagraphContainerView,
                layer=IPyAMSLayer, manager=IToolbarAddingMenu, weight=600)
class SharedContentSpecificitiesParagraphAddMenu(BaseParagraphAddMenu):
    """Shared Content Specificities paragraph add menu"""

    label = _("Content specificities...")
    label_css_class = 'fa fa-fw ' + SharedContentSpecificitiesParagraph.icon_class

    url = 'add-specificities-paragraph.html'
    paragraph_type = SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_TYPE


@pagelet_config(name='add-specificities-paragraph.html', context=IParagraphContainerTarget, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='add-specificities-paragraph.json', context=IParagraphContainerTarget, layer=IPyAMSLayer,
             base=BaseParagraphAJAXAddForm)
class SharedContentSpecificitiesParagraphAddForm(BaseParagraphAddForm):
    """Shared Content Specificities paragraph add form"""

    legend = _("Add shared content specificities")
    dialog_class = 'modal-large'

    content_interface = ISharedContentSpecificitiesParagraph


@pagelet_config(name='properties.html', context=ISharedContentSpecificitiesParagraph, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='properties.json', context=ISharedContentSpecificitiesParagraph, request_type=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
class SharedContentSpecificitiesParagraphPropertiesEditForm(BaseParagraphPropertiesEditForm):
    """Shared content specificities paragraph properties edit form"""

    prefix = 'specificities_properties.'

    legend = _("Edit specificities properties")

    content_interface = ISharedContentSpecificitiesParagraph


@adapter_config(context=(ISharedContentSpecificitiesParagraph, IPyAMSLayer), provides=IParagraphInnerEditor)
@ajax_config(name='inner-properties.json', context=SharedContentSpecificitiesParagraph, layer=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
@implementer(IInnerForm)
class SharedContentSpecificitiesParagraphInnerEditForm(SharedContentSpecificitiesParagraphPropertiesEditForm):
    """Shared Content specificities paragraph inner edit form"""

    legend = None

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IParagraphInnerEditFormButtons)
        else:
            return button.Buttons()
