#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import button, field
from z3c.form.interfaces import INPUT_MODE
from zope.interface import Interface, implementer

from pyams_content import _
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.help import FormHelp
from pyams_form.interfaces.form import IFormHelp, IUncheckedEditFormButtons, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_sequence.interfaces import IInternalReferencesList
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


@viewlet_config(name='references.menu', context=IInternalReferencesList, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=VIEW_SYSTEM_PERMISSION, weight=300)
class ReferencesMenu(MenuItem):
    """Internal references menu"""

    label = _("References...")
    icon_class = 'fa-external-link-square fa-rotate-90'
    url = '#references.html'


@pagelet_config(name='references.html', context=IInternalReferencesList, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='references.json', context=IInternalReferencesList, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class InternalReferencesEditForm(AdminEditForm):
    """Internal references edit form"""

    legend = _("Internal references settings")

    fields = field.Fields(IInternalReferencesList)

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        else:
            return button.Buttons(Interface)


@adapter_config(context=(IInternalReferencesList, IPyAMSLayer, InternalReferencesEditForm), provides=IFormHelp)
class InternalReferencesEditFormHelp(FormHelp):
    """Internal references edit form help"""

    message = _("Internal references selected here will be usable by views which are using references "
                "defined by their application context.")
    message_format = 'rest'
