#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import IWfSharedContent
from pyams_form.interfaces.form import IFormContextPermissionChecker
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_i18n.zmi.language import I18nManagerLanguagesEditForm
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter


@adapter_config(context=(IWfSharedContent, IPyAMSLayer, I18nManagerLanguagesEditForm),
                provides=IFormContextPermissionChecker)
class SharedContentLanguageEditFormPermissionChecker(ContextRequestViewAdapter):
    """I18n manager language edit form permission checker"""

    @property
    def edit_permission(self):
        return IFormContextPermissionChecker(self.context).edit_permission
