#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema.fieldproperty import FieldProperty

from pyams_content.shared.common.portlet.interfaces import ISharedContentTitlePortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from pyams_content import _


SHARED_CONTENT_TITLE_PORTLET_NAME = 'pyams_content.portlet.shared.title'


@factory_config(provided=ISharedContentTitlePortletSettings)
class SharedContentTitlePortletSettings(PortletSettings):
    """Shared content title portlet settings"""

    display_publication_date = FieldProperty(
        ISharedContentTitlePortletSettings['display_publication_date'])
    publication_date_prefix = FieldProperty(
        ISharedContentTitlePortletSettings['publication_date_prefix'])


@portlet_config(permission=VIEW_PERMISSION)
class SharedContentTitlePortlet(Portlet):
    """Shared content title portlet"""

    name = SHARED_CONTENT_TITLE_PORTLET_NAME
    label = _("Content title")

    toolbar_css_class = 'fa fa-fw fa-2x fa-bold'

    settings_factory = ISharedContentTitlePortletSettings
