#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content import _
from pyams_content.shared.common.portlet.interfaces import \
    ISharedContentSpecificitiesPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION


#
# Shared content specificities portlet
#

SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME = 'pyams_content.portlet.shared.specificities'


@factory_config(provided=ISharedContentSpecificitiesPortletSettings)
class SharedContentSpecificitiesPortletSettings(PortletSettings):
    """Shared content specificities portlet settings"""


@portlet_config(permission=VIEW_PERMISSION)
class SharedContentSpecificitiesPortlet(Portlet):
    """Shared content specificities portlet"""

    name = SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME
    label = _("Content specificities portlet")

    toolbar_css_class = 'fa fa-fw fa-2x fa-paperclip'

    settings_factory = ISharedContentSpecificitiesPortletSettings
