#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import IBaseSharedTool, IBaseContentPortalContext
from pyams_portal.interfaces import IPortalPage, PORTAL_PAGE_KEY

# import packages
from pyams_portal.page import PortalPage
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.traversing import get_parent


class SharedContentPortalPage(PortalPage):
    """Shared content portal page"""

    @property
    def can_inherit(self):
        return IPortalPage(self.parent).template is not None

    @property
    def parent(self):
        return get_parent(self, IBaseSharedTool, allow_context=False)


@adapter_config(context=IBaseContentPortalContext, provides=IPortalPage)
def shared_content_portal_page_adapter(context):
    """Shared content portal page adapter"""
    return get_annotation_adapter(context, PORTAL_PAGE_KEY, SharedContentPortalPage)
