#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.view import view_config
from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION
from pyams_content.shared.calendar.interfaces import ICalendarManager, IWfCalendarEvent
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_form.form import ajax_config
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from pyams_content import _


@adapter_config(context=(IWfCalendarEvent, IContentManagementMenu), provides=IMenuHeader)
class CalendarEventContentMenuHeader(ContextRequestAdapter):
    """Calendar event content menu header adapter"""

    header = _("This calendar event")


@adapter_config(context=(IWfCalendarEvent, IPyAMSLayer, Interface), provides=IContentTitle)
class CalendarEventTitleAdapter(ContextRequestViewAdapter):
    """Calendar event title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Calendar event « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action',
                context=ICalendarManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, weight=1,
                permission=CREATE_CONTENT_PERMISSION)
class CalendarEventAddAction(ToolbarAction):
    """Calendar event adding action"""

    label = _("Add calendar event")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html',
                context=ICalendarManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class CalendarEventAddForm(SharedContentAddForm):
    """Calendar event add form"""

    legend = _("Add calendar event")


@view_config(name='add-shared-content.json',
             context=ICalendarManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, renderer='json', xhr=True)
class CalendarEventAJAXAddForm(SharedContentAJAXAddForm, CalendarEventAddForm):
    """Calendar event add form, JSON renderer"""


@pagelet_config(name='properties.html',
                context=IWfCalendarEvent, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json',
             context=IWfCalendarEvent, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class CalendarEventPropertiesEditForm(SharedContentPropertiesEditForm):
    """Calendar event properties edit form"""

    interface = IWfCalendarEvent
    fieldnames = ('title', 'short_name', 'content_url',
                  'header', 'description', 'notepad')
