#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.paragraph import IParagraphFactorySettings
from pyams_content.component.theme import IThemesManagerTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.shared.calendar import CalendarEvent
from pyams_content.shared.calendar.interfaces import CALENDAR_CONTENT_TYPE, ICalendarManager, \
    ICalendarManagerFactory
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


@implementer(ICalendarManager, IParagraphFactorySettings, IThemesManagerTarget,
             IPictogramManagerTarget)
class CalendarManager(SharedTool):
    """Calendar manager class"""

    shared_content_type = CALENDAR_CONTENT_TYPE

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])


@utility_config(provides=ICalendarManagerFactory)
class CalendarManagerFactory:
    """Calendar manager factory"""

    def __new__(cls):
        return CalendarManager


@adapter_config(context=ICalendarManager,
                provides=ISharedContentFactory)
def calendar_manager_content_factory(context):
    return CalendarEvent


@subscriber(IObjectAddedEvent, context_selector=ICalendarManager)
def handle_added_news_manager(event):
    """Register calendar manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, ICalendarManager)
