#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from pyams_content.shared.common import ISharedContent
from pyams_content.shared.common.interfaces import ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_sequence.interfaces import IInternalReferencesList


__docformat__ = 'restructuredtext'

from pyams_content import _


CALENDAR_CONTENT_TYPE = 'calendar'
CALENDAR_CONTENT_NAME = _("Calendar event")


class ICalendarManager(ISharedToolPortalContext):
    """Calendar manager interface"""


class ICalendarManagerFactory(Interface):
    """Calendar manager factory interface"""


class IWfCalendarEvent(IWfSharedContentPortalContext, IInternalReferencesList):
    """Calendar event interface"""


class IWfCalendarEventFactory(Interface):
    """Calendar event factory interface"""


class ICalendarEvent(ISharedContent):
    """Workflow managed calendar event interface"""
