#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.calendar import ICalendarTarget
from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph import IParagraphContainerTarget
from pyams_content.component.theme import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review import IReviewTarget
from pyams_content.shared.calendar.interfaces import CALENDAR_CONTENT_NAME, CALENDAR_CONTENT_TYPE, \
    ICalendarEvent, IWfCalendarEvent, IWfCalendarEventFactory
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, \
    register_content_type
from pyams_utils.adapter import adapter_config


@implementer(IWfCalendarEvent, IIllustrationTarget, ILinkIllustrationTarget,
             IParagraphContainerTarget, ICalendarTarget, ITagsTarget, IThemesTarget,
             IPreviewTarget, IReviewTarget)
class WfCalendarEvent(WfSharedContent):
    """Base calendar event"""

    content_type = CALENDAR_CONTENT_TYPE
    content_name = CALENDAR_CONTENT_NAME

    references = FieldProperty(IWfCalendarEvent['references'])

register_content_type(WfCalendarEvent)


@provider(IWfCalendarEventFactory)
@implementer(ICalendarEvent)
class CalendarEvent(SharedContent):
    """Workflow managed news event class"""


@adapter_config(context=IWfCalendarEventFactory,
                provides=IWfSharedContentFactory)
def calendar_event_content_factory(context):
    return WfCalendarEvent
