#
# Copyright (c) 2008-2016 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.container.constraints import containers, contains
from zope.container.interfaces import IContainer
from zope.interface import Attribute, Interface
from zope.schema import Text

from pyams_content import _
from pyams_content.shared.common.interfaces import IBaseSharedTool, IDeletableElement, ISharedContent, ISharedSite, \
    IWfSharedContentPortalContext
from pyams_i18n.schema import I18nTextField
from pyams_sequence.interfaces import IInternalReferencesList, ISequentialIdTarget
from pyams_workflow.interfaces import IWorkflowPublicationSupport


BLOG_CONTENT_TYPE = 'blog'
BLOG_CONTENT_NAME = _("Blog post")


class IWfBlogPost(IWfSharedContentPortalContext, IInternalReferencesList):
    """Blog topic interface"""


class IWfBlogPostFactory(Interface):
    """Blog post factory interface"""


class IBlogPost(ISharedContent, IDeletableElement):
    """Workflow managed blog post interface"""

    containers('.IBlogFolder')


class IBlogFolder(IContainer, IDeletableElement):
    """Blog folder interface"""

    containers('.IBlogManager', '.IBlogFolder')
    contains('.IBlogFolder', '.IBlogPost')


class IBlogFolderFactory(Interface):
    """Blog folder factory interface"""


class IBlogManager(ISharedSite, IBaseSharedTool, IWorkflowPublicationSupport, IDeletableElement, ISequentialIdTarget):
    """Blog manager interface"""

    contains(IBlogFolder)

    folder_factory = Attribute("Blog folder factory")

    topic_content_type = Attribute("Topic content type")
    topic_content_factory = Attribute("Topic content factory")

    description = I18nTextField(title=_("Meta-description"),
                                description=_("The blog's description is 'hidden' into HTML's page headers; but it "
                                              "can be seen, for example, in some search engines results as content's "
                                              "description; if description is empty, content's header will be used."),
                                required=False)

    notepad = Text(title=_("Notepad"),
                   description=_("Internal information to be known about this content"),
                   required=False)


class IBlogManagerFactory(Interface):
    """Blog manager factory interface"""
