#
# Copyright (c) 2008-2016 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.blog.interfaces import BLOG_CONTENT_NAME, BLOG_CONTENT_TYPE, IBlogPost, IWfBlogPost, \
    IWfBlogPostFactory
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, register_content_type
from pyams_utils.adapter import adapter_config
from pyams_workflow.interfaces import IWorkflow, IWorkflowState, IWorkflowVersions


@implementer(IWfBlogPost, IParagraphContainerTarget, ITagsTarget, IThemesTarget, IIllustrationTarget,
             ILinkIllustrationTarget, IPreviewTarget, IReviewTarget)
class WfBlogPost(WfSharedContent):
    """Base blog post"""

    content_type = BLOG_CONTENT_TYPE
    content_name = BLOG_CONTENT_NAME

    references = FieldProperty(IWfBlogPost['references'])

register_content_type(WfBlogPost)


@provider(IWfBlogPostFactory)
@implementer(IBlogPost)
class BlogPost(SharedContent):
    """Worfklow managed blog post class"""

    def is_deletable(self):
        workflow = IWorkflow(self)
        for version in IWorkflowVersions(self).get_versions():
            if IWorkflowState(version).state != workflow.initial_state:
                return False
        return True


@adapter_config(context=IWfBlogPostFactory, provides=IWfSharedContentFactory)
def blog_post_content_factory(context):
    return WfBlogPost
