#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.view import view_config
from z3c.form.field import Fields
from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.alert import IWfAlert
from pyams_content.shared.alert.interfaces import IAlertsManager
from pyams_content.shared.common import IDashboardTypeColumnValue
from pyams_content.shared.common.interfaces.zmi import IDashboardTable
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_i18n.interfaces import II18n
from pyams_i18n.widget import I18nSEOTextLineFieldWidget
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from pyams_content import _


@adapter_config(required=(IWfAlert, IContentManagementMenu),
                provides=IMenuHeader)
class AlertContentMenuHeader(ContextRequestAdapter):
    """Alert content menu header adapter"""

    header = _("This alert")


@adapter_config(required=(IWfAlert, IPyAMSLayer, Interface),
                provides=IContentTitle)
class AlertTitleAdapter(ContextRequestViewAdapter):
    """Alert title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Alert « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action',
                context=IAlertsManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, weight=1,
                permission=CREATE_CONTENT_PERMISSION)
class AlertAddAction(ToolbarAction):
    """Alert adding action"""

    label = _("Add alert")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html',
                context=IAlertsManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class AlertAddForm(SharedContentAddForm):
    """Alert add form"""

    legend = _("Add alert")

    fields = Fields(IWfAlert).select('title', 'alert_type', 'notepad')
    fields['title'].widgetFactory = I18nSEOTextLineFieldWidget


@view_config(name='add-shared-content.json',
             context=IAlertsManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION,
             renderer='json', xhr=True)
class AlertAJAXAddForm(SharedContentAJAXAddForm, AlertAddForm):
    """Alert add form, JSON renderer"""


@adapter_config(required=(IWfAlert, IAdminLayer, IDashboardTable),
                provides=IDashboardTypeColumnValue)
def alert_dashboard_type_adapter(context, request, view):
    """Alert dashboard type column adapter"""
    alert_type = context.get_alert_type()
    if alert_type is not None:
        return II18n(alert_type).query_attribute('backoffice_label', request=request) or \
            II18n(alert_type).query_attribute('label', request=request)
