#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute, Interface
from zope.schema import URI

from pyams_content.interfaces import OPERATOR_ROLE, WEBMASTER_ROLE
from pyams_portal.interfaces import DESIGNER_ROLE
from pyams_security.interfaces import SYSTEM_ADMIN_ROLE
from pyams_security.schema import Principal, PrincipalsSet
from pyams_skin.interfaces.configuration import IBackOfficeConfiguration, IConfiguration
from pyams_utils.interfaces.site import ISiteRoot as ISiteRootBase

__docformat__ = 'restructuredtext'

from pyams_content import _


class ISiteRoot(ISiteRootBase):
    """Main site root interface"""


class ISiteRootRoles(Interface):
    """Main site roles"""

    managers = PrincipalsSet(title=_("Site managers"),
                             role_id=SYSTEM_ADMIN_ROLE,
                             required=False)

    webmasters = PrincipalsSet(title=_("Webmasters"),
                               role_id=WEBMASTER_ROLE,
                               required=False)

    designers = PrincipalsSet(title=_("Templates managers"),
                              role_id=DESIGNER_ROLE,
                              required=False)

    operators = Principal(title=_("Operators group"),
                          description=_("Name of group containing all roles owners"),
                          role_id=OPERATOR_ROLE,
                          required=False)


class ISiteRootConfiguration(IConfiguration):
    """Site root configuration interface"""

    public_url = URI(title=_("Public URL"),
                     description=_("Base URL of the public site"),
                     required=False)


class ISiteRootToolsConfiguration(Interface):
    """Site root tools configuration interface"""

    tables_name = Attribute("References tables manager name")

    pictograms_table_name = Attribute("Pictograms reference table name")

    tools_name = Attribute("Tools name")

    views_tool_name = Attribute("Views tool name")
    forms_tool_name = Attribute("Forms tool name")
    imagemaps_tool_name = Attribute("Image maps tool name")
    logos_tool_name = Attribute("Logos tool name")

    news_tool_name = Attribute("News tool name")
    topics_tool_name = Attribute("Topics tool name")
    calendar_tool_name = Attribute("Calendar tool name")


class ISiteRootBackOfficeConfiguration(IBackOfficeConfiguration):
    """Site root back-office configuration interface"""
