#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

from z3c.form.widget import FieldWidget
from zope.interface import implementer

from pyams_content import _
# import interfaces
from pyams_content.reference.pictograms import IPictogramTable
# import packages
from pyams_content.reference.pictograms.zmi import get_pictogram_header
from pyams_form.widget import Select2Widget
from pyams_utils.interfaces.data import IObjectData
from pyams_utils.registry import query_utility
from pyams_utils.url import absolute_url


@implementer(IObjectData)
class PictogramSelectWidget(Select2Widget):
    """Pictogram selection widget"""

    noValueMessage = _("No selected pictogram")

    pictograms = None
    label_id = None
    after_widget_notice = None

    def update(self):
        super(PictogramSelectWidget, self).update()
        self.label_id = '{0}_header'.format(self.id)
        self.pictograms = query_utility(IPictogramTable)
        if self.value and (self.pictograms is not None):
            pictogram = self.pictograms.get(self.value[0])
            if pictogram is not None:
                self.after_widget_notice = '<span id="{0}" class="text-info">{1}</span>'.format(
                    self.label_id,
                    get_pictogram_header(pictogram, self.request))
                return
        self.after_widget_notice = '<span id="{0}" class="text-info">{1}</span>'.format(
            self.label_id,
            self.request.localizer.translate(_("Default header: --")))

    @property
    def object_data(self):
        return {
            'ams-change-handler': 'MyAMS.helpers.select2ChangeHelper',
            'ams-stop-propagation': 'true',
            'ams-select2-helper-type': 'html',
            'ams-select2-helper-url': absolute_url(self.pictograms, self.request, 'get-pictogram-header.html'),
            'ams-select2-helper-target': '#{0}'.format(self.label_id)
        }


def PictogramSelectFieldWidget(field, request):
    return FieldWidget(field, PictogramSelectWidget(request))
