#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""
from persistent import Persistent
from zope.container.contained import Contained
from zope.schema.fieldproperty import FieldProperty

from pyams_content.reference.pictograms.interfaces import IThesaurusTermPictogramsInfo, IThesaurusTermPictogramsTarget, \
    THESAURUS_TERM_PICTOGRAMS_KEY
from pyams_thesaurus.interfaces.extension import IThesaurusTermExtension
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.registry import utility_config

from pyams_content import _


@factory_config(provided=IThesaurusTermPictogramsInfo)
class ThesaurusTermPictogramInfo(Persistent, Contained):
    """Thesaurus term pictograms"""

    pictogram_on = FieldProperty(IThesaurusTermPictogramsInfo['pictogram_on'])
    pictogram_off = FieldProperty(IThesaurusTermPictogramsInfo['pictogram_off'])


@adapter_config(context=IThesaurusTermPictogramsTarget,
                provides=IThesaurusTermPictogramsInfo)
def thesaurus_term_pictograms_factory(context):
    """Thesaurus term Pictograms factory"""
    return get_annotation_adapter(context, THESAURUS_TERM_PICTOGRAMS_KEY, IThesaurusTermPictogramsInfo)


@utility_config(name='pictograms', provides=IThesaurusTermExtension)
class PictogramThesaurusExtension:
    """Pictograms thesaurus extension"""

    label = _("Pictograms")
    weight = 30

    target_interface = IThesaurusTermPictogramsTarget
    target_view = "pictograms-description.html"

    icon = '<i class="fa fa-fw fa-camera"></i>'
