#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.interfaces import IBaseContent
from zope.container.interfaces import IContainer

# import packages
from zope.container.constraints import containers, contains


class IReferenceInfo(IBaseContent):
    """Base reference interface"""

    containers('.IReferenceTable')


class IReferenceTable(IBaseContent):
    """Reference table interface"""

    containers('.IReferenceTableContainer')
    contains(IReferenceInfo)


class IReferenceManager(IBaseContent, IContainer):
    """References tables container"""

    contains(IReferenceTable)
